using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using Phidgets;
using Phidgets.Events;

namespace RFID_Controller
{
    public partial class Form1 : Form
    {
        RFID rfid;
        public Form1()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            rfid = new RFID();
            rfid.Attach += new AttachEventHandler(rfid_Attach);
            rfid.Detach += new DetachEventHandler(rfid_Detach);
            rfid.Tag += new TagEventHandler(rfid_Tag);
            rfid.TagLost += new TagEventHandler(rfid_TagLost);
            rfid.open();
        }

        void rfid_TagLost(object sender, TagEventArgs e)
        {
            if (InvokeRequired)
                Invoke(new TagEventHandler(rfid_TagLost),
                            new object[] { sender, e });
            else
            {
                tagTextBox.Text = "";
            }
        }

        void rfid_Tag(object sender, TagEventArgs e)
        {
            if (InvokeRequired)
                Invoke(new TagEventHandler(rfid_Tag),
                            new object[] { sender, e });
            else
            {
                tagTextBox.Text = e.Tag;
            }
        }

        void rfid_Detach(object sender, DetachEventArgs e)
        {
            if (InvokeRequired)
                Invoke(new DetachEventHandler(rfid_Detach),
                            new object[] { sender, e });
            else
            {
                attachedLabel.Text = "Not Attached";
            }
        }

        void rfid_Attach(object sender, AttachEventArgs e)
        {
            if (InvokeRequired)
                Invoke(new AttachEventHandler(rfid_Attach),
                            new object[] { sender, e });
            else
            {
                Phidgets.RFID phid = (Phidgets.RFID)sender;
                attachedLabel.Text = "Attached: " + phid.Name;
                serialLabel.Text = " Serial: " + phid.SerialNumber;
                versionLabel.Text = " Version: " + phid.Version;

                outputsLabel.Text = "Outputs: " + phid.outputs.Count;
            }
        }

        private void antennaCheckBox_CheckedChanged(object sender, EventArgs e)
        {
            rfid.Antenna = antennaCheckBox.Checked;
        }

        private void ledCheckBox_CheckedChanged(object sender, EventArgs e)
        {
            rfid.LED = ledCheckBox.Checked;
        }

        private void output0CheckBox_CheckedChanged(object sender, EventArgs e)
        {
            rfid.outputs[0] = output0CheckBox.Checked;
        }

        private void output1CheckBox_CheckedChanged(object sender, EventArgs e)
        {
            rfid.outputs[1] = output1CheckBox.Checked;
        }
    }
}